<?php
// Basic Admin Authentication (Placeholder - Use a proper system later)
session_start();

$admin_user = "admin";
$admin_pass_hash = password_hash("admin123", PASSWORD_DEFAULT); // Store hash securely

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $_POST["username"] ?? 
null;
    $password = $_POST["password"] ?? 
null;

    if ($username === $admin_user && password_verify($password, $admin_pass_hash)) {
        $_SESSION["admin_loggedin"] = true;
        header("Location: index.php");
        exit;
    } else {
        $error = "Geçersiz kullanıcı adı veya şifre.";
    }
}

// If already logged in, redirect to index
if (isset($_SESSION["admin_loggedin"]) && $_SESSION["admin_loggedin"] === true) {
    header("Location: index.php");
    exit;
}

?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Yönetim Paneli Girişi</title>
    <style>
        body { font-family: sans-serif; display: flex; justify-content: center; align-items: center; min-height: 100vh; background-color: #f4f4f4; }
        .login-container { background: #fff; padding: 30px; border-radius: 5px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .login-container h2 { text-align: center; margin-bottom: 20px; }
        .login-container div { margin-bottom: 15px; }
        .login-container label { display: block; margin-bottom: 5px; }
        .login-container input[type="text"], .login-container input[type="password"] { width: 100%; padding: 10px; border: 1px solid #ccc; border-radius: 3px; box-sizing: border-box; }
        .login-container button { width: 100%; padding: 10px; background-color: #5cb85c; color: white; border: none; border-radius: 3px; cursor: pointer; font-size: 16px; }
        .login-container button:hover { background-color: #4cae4c; }
        .error { color: red; text-align: center; margin-top: 10px; }
    </style>
</head>
<body>
    <div class="login-container">
        <h2>Yönetim Paneli Girişi</h2>
        <?php if (isset($error)): ?>
            <p class="error"><?php echo $error; ?></p>
        <?php endif; ?>
        <form action="login.php" method="post">
            <div>
                <label for="username">Kullanıcı Adı:</label>
                <input type="text" id="username" name="username" required>
            </div>
            <div>
                <label for="password">Şifre:</label>
                <input type="password" id="password" name="password" required>
            </div>
            <button type="submit">Giriş Yap</button>
        </form>
    </div>
</body>
</html>
