<?php
require_once __DIR__ . '/admin_auth_check.php'; // Fixed path

// Placeholder for fetching users (Requires DB)
$users = []; // Initialize as empty array

// --- Database Interaction ---
require_once __DIR__ . '/../config/db.php'; // Fixed path
$mysqli = connect_db();

$sql_users = "
    SELECT 
        u.user_id, u.email, u.created_at, 
        -- Use last_login to determine online status (adjust threshold as needed)
        (u.last_login >= DATE_SUB(NOW(), INTERVAL 5 MINUTE)) as online_status, 
        p.username, 
        m.name as membership,
        GROUP_CONCAT(ph.photo_id SEPARATOR '||') as photo_ids,
        GROUP_CONCAT(ph.file_path SEPARATOR '||') as photo_paths
    FROM users u
    LEFT JOIN profiles p ON u.user_id = p.user_id
    LEFT JOIN memberships m ON u.membership_id = m.membership_id
    LEFT JOIN photos ph ON u.user_id = ph.user_id
    WHERE u.is_admin = 0 -- Exclude admin users from the list
    GROUP BY u.user_id
    ORDER BY u.created_at DESC;
";

if ($result = $mysqli->query($sql_users)) {
    while ($row = $result->fetch_assoc()) {
        // Process photos from concatenated strings
        $photo_data = [];
        if ($row['photo_ids']) {
            $ids = explode('||', $row['photo_ids']);
            $paths = explode('||', $row['photo_paths']);
            for ($i = 0; $i < count($ids); $i++) {
                // Construct web path relative to the public directory
                // Assuming file_path is like 'uploads/image.jpg'
                $web_path = '../' . $paths[$i]; 
                $photo_data[] = ['photo_id' => $ids[$i], 'file_path' => $web_path]; 
            }
        }
        $row['photos'] = $photo_data;
        unset($row['photo_ids'], $row['photo_paths']);
        $users[] = $row;
    }
    $result->free();
} else {
    error_log("Admin DB Error (fetch users): " . $mysqli->error);
}
close_db($mysqli);


?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kullanıcı Yönetimi</title>
    <style>
        body { font-family: sans-serif; margin: 0; display: flex; min-height: 100vh; background-color: #f4f4f4; }
        .sidebar { width: 220px; background: #2c3e50; /* Dark blue */ color: white; flex-shrink: 0; display: flex; flex-direction: column; }
        .sidebar h2 { text-align: center; color: #ecf0f1; /* Light grey */ margin: 20px 0; padding-bottom: 20px; border-bottom: 1px solid #34495e; /* Slightly darker blue */ font-size: 1.5em; }
        .sidebar ul { list-style: none; padding: 0; margin: 0; flex-grow: 1; }
        .sidebar ul li a {
            display: block;
            padding: 15px 25px;
            color: #bdc3c7; /* Silver */
            text-decoration: none;
            border-left: 4px solid transparent;
            transition: all 0.3s ease;
        }
        .sidebar ul li a:hover {
            background: #34495e; /* Slightly darker blue */
            color: #fff;
            border-left-color: #e91e63; /* Pink accent */
        }
        .sidebar ul li a.active {
            background: #34495e;
            color: #fff;
            font-weight: bold;
            border-left-color: #e91e63;
        }
         .sidebar .logout-link {
             margin-top: auto; /* Pushes logout to bottom */
        }
         .sidebar .logout-link a {
             border-top: 1px solid #34495e;
             border-bottom: none; /* Remove bottom border for logout */
         }

        .main-content { flex-grow: 1; padding: 30px; overflow-x: auto; /* Allow horizontal scroll on small screens */}
        .main-content h1 {
            margin-top: 0;
            color: #2c3e50;
            border-bottom: 2px solid #e91e63;
            padding-bottom: 10px;
            margin-bottom: 30px;
        }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; background: #fff; box-shadow: 0 4px 10px rgba(0,0,0,0.08); font-size: 0.9em; }
        th, td { padding: 10px 12px; border: 1px solid #ddd; text-align: left; vertical-align: middle; }
        th { background-color: #ecf0f1; /* Light grey */ color: #34495e; /* Darker blue text */ font-weight: 600; }
        tr:nth-child(even) { background-color: #f9f9f9; }
        tr:hover { background-color: #f1f1f1; }
        .status-online { color: #2ecc71; /* Green */ font-weight: bold; }
        .status-offline { color: #e74c3c; /* Red */ }
        .user-photos { white-space: nowrap; /* Prevent wrapping */ }
        .user-photos img {
             width: 40px; 
             height: 40px; 
             margin: 3px; 
             border: 1px solid #ccc; 
             cursor: pointer; 
             object-fit: cover; 
             border-radius: 4px; 
             transition: transform 0.2s ease;
        }
        .user-photos img:hover {
            transform: scale(1.1);
            border-color: #e91e63;
        }
        .actions button {
            padding: 5px 10px;
            margin-right: 5px;
            font-size: 0.85em;
            cursor: pointer;
            border: 1px solid #ccc;
            border-radius: 4px;
            background-color: #eee;
        }
        .actions button:hover {
            background-color: #ddd;
        }
        .actions button:disabled {
            cursor: not-allowed;
            opacity: 0.6;
        }

        /* Modal styles */
        .modal { display: none; position: fixed; z-index: 1000; left: 0; top: 0; width: 100%; height: 100%; overflow: auto; background-color: rgba(0,0,0,0.8); align-items: center; justify-content: center; }
        .modal-content { display: block; max-width: 85%; max-height: 85%; margin: auto; }
        .close { position: absolute; top: 20px; right: 35px; color: #f1f1f1; font-size: 45px; font-weight: bold; cursor: pointer; transition: color 0.3s ease; }
        .close:hover, .close:focus { color: #bbb; text-decoration: none; }

         @media (max-width: 768px) {
            body { flex-direction: column; }
            .sidebar { width: 100%; min-height: auto; flex-direction: row; justify-content: space-between; align-items: center; padding: 0 10px; }
            .sidebar h2 { margin: 10px 0; padding: 0; border: none; font-size: 1.2em; }
            .sidebar ul { display: flex; flex-grow: 0; border-bottom: none; }
            .sidebar ul li a { padding: 10px; border: none; font-size: 0.9em; }
            .sidebar ul li a:hover, .sidebar ul li a.active { background: #34495e; border-left: none; }
            .sidebar .logout-link { margin-top: 0; }
            .main-content { padding: 15px; }
            table { font-size: 0.8em; }
            th, td { padding: 8px 10px; }
            .user-photos img { width: 30px; height: 30px; }
            .actions button { font-size: 0.8em; padding: 4px 8px; }
        }
    </style>
</head>
<body>
    <div class="sidebar">
        <h2>Yönetim</h2>
        <ul>
            <li><a href="index.php">Panel</a></li>
            <li><a href="users.php" class="active">Kullanıcılar</a></li>
            <!-- Add more links later -->
        </ul>
         <div class="logout-link">
             <ul><li><a href="logout.php">Çıkış Yap</a></li></ul>
         </div>
    </div>
    <div class="main-content">
        <h1>Kullanıcı Yönetimi</h1>
        
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>E-posta</th>
                    <th>Kullanıcı Adı</th>
                    <th>Üyelik</th>
                    <th>Kayıt Tarihi</th>
                    <th>Durum</th>
                    <th>Fotoğraflar</th>
                    <th>İşlemler</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($users)): ?>
                    <?php foreach ($users as $user): ?>
                    <tr>
                        <td><?php echo $user["user_id"]; ?></td>
                        <td><?php echo htmlspecialchars($user["email"]); ?></td>
                        <td><?php echo htmlspecialchars($user["username"] ?? 'N/A'); ?></td>
                        <td><?php echo htmlspecialchars($user["membership"] ?? 'N/A'); ?></td>
                        <td><?php echo date('d.m.Y H:i', strtotime($user["created_at"])); ?></td>
                        <td>
                            <span class="<?php echo $user["online_status"] ? 'status-online' : 'status-offline'; ?>">
                                <?php echo $user["online_status"] ? 'Çevrimiçi' : 'Çevrimdışı'; ?>
                            </span>
                        </td>
                        <td class="user-photos">
                            <?php if (!empty($user["photos"])): ?>
                                <?php foreach ($user["photos"] as $photo): ?>
                                    <img src="<?php echo htmlspecialchars($photo['file_path']); ?>" alt="Foto <?php echo $photo['photo_id']; ?>" onclick="openModal('<?php echo htmlspecialchars($photo['file_path']); ?>')">
                                <?php endforeach; ?>
                            <?php else: ?>
                                Yok
                            <?php endif; ?>
                        </td>
                        <td class="actions">
                            <!-- Add actions like Edit, Delete, Ban later -->
                            <button disabled>Düzenle</button>
                            <button disabled>Sil</button>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                <tr>
                    <td colspan="8" style="text-align: center;">Kullanıcı bulunamadı.</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <!-- The Modal -->
    <div id="myModal" class="modal">
      <span class="close" onclick="closeModal()">&times;</span>
      <img class="modal-content" id="img01">
    </div>

    <script>
        // Get the modal
        var modal = document.getElementById("myModal");
        var modalImg = document.getElementById("img01");

        function openModal(imgSrc) {
            modal.style.display = "flex"; // Use flex for centering
            modalImg.src = imgSrc;
        }

        function closeModal() {
            modal.style.display = "none";
        }

        // Close if clicked outside the image
        modal.onclick = function(event) {
            if (event.target == modal) {
                closeModal();
            }
        }
    </script>

</body>
</html>