<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Flört Uygulaması - Hoş Geldiniz</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            line-height: 1.6;
            margin: 0;
            padding: 0;
            background-color: #f4f7f6;
            color: #333;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            text-align: center;
        }
        .container {
            background: #fff;
            padding: 40px 50px;
            border-radius: 8px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
            max-width: 500px;
            width: 90%;
        }
        h1 {
            color: #e91e63; /* Pembe tonu */
            margin-bottom: 15px;
        }
        p {
            margin-bottom: 30px;
            color: #555;
        }
        .buttons a {
            display: inline-block;
            padding: 12px 25px;
            margin: 10px;
            border-radius: 25px;
            text-decoration: none;
            font-weight: bold;
            transition: background-color 0.3s ease, transform 0.2s ease;
        }
        .btn-login {
            background-color: #e91e63;
            color: white;
            border: 1px solid #e91e63;
        }
        .btn-login:hover {
            background-color: #c2185b;
            transform: translateY(-2px);
        }
        .btn-register {
            background-color: #fff;
            color: #e91e63;
            border: 1px solid #e91e63;
        }
        .btn-register:hover {
            background-color: #f8bbd0; /* Açık pembe */
            transform: translateY(-2px);
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Flört Uygulamasına Hoş Geldiniz!</h1>
        <p>Yeni insanlarla tanışın, sohbet edin ve belki de aradığınız aşkı bulun. Hemen başlayın!</p>
        <div class="buttons">
            <a href="login.php" class="btn-login">Giriş Yap</a>
            <a href="register.php" class="btn-register">Kayıt Ol</a>
        </div>
    </div>
</body>
</html>

