# Infernova - Basit Arkadaşlık Uygulaması

Bu proje, PHP ve MySQL kullanılarak geliştirilmiş basit bir web tabanlı arkadaşlık uygulamasıdır.

## Proje Yapısı

```
/
|-- config/
|   `-- db.php             # Veritabanı bağlantı ayarları
|
|-- includes/
|   |-- auth_check.php       # Kullanıcı oturum kontrolü
|   |-- like_process_fix.php # Beğeni/Eşleşme işlemleri
|   |-- login_process_fix.php  # Giriş işlemi mantığı
|   |-- logout.php           # Çıkış işlemi
|   |-- profile_process_fix.php # Profil güncelleme/fotoğraf yükleme işlemleri
|   |-- register_process_fix.php # Kayıt işlemi mantığı
|   `-- send_message_fix.php   # Mesaj gönderme işlemi
|
|-- public/
|   |-- css/                 # CSS dosyaları (örneğin, style.css)
|   |-- images/              # Logo gibi genel görseller
|   |   `-- logo.png
|   |-- uploads/             # Kullanıcı tarafından yüklenen fotoğrafların saklanacağı yer (sunucuda oluşturulmalı ve yazma izni verilmeli)
|   |-- index.php            # Ana karşılama sayfası
|   |-- login.php            # Giriş sayfası
|   |-- register.php         # Kayıt sayfası
|   |-- dashboard.php        # Kullanıcı paneli (giriş sonrası)
|   |-- profile.php          # Profil görüntüleme/düzenleme sayfası
|   |-- find_matches.php     # Eşleşme arama sayfası
|   |-- messages.php         # Mesaj listesi sayfası
|   `-- conversation.php     # Tekil konuşma sayfası
|
|-- admin/
|   |-- index.php            # Yönetici paneli ana sayfası (admin_index_fix.php olarak yeniden adlandırıldı)
|   |-- login.php            # Yönetici giriş sayfası (admin_login.php olarak yeniden adlandırıldı)
|   |-- logout.php           # Yönetici çıkış işlemi (admin_logout.php olarak yeniden adlandırıldı)
|   |-- users.php            # Kullanıcı listeleme sayfası (admin_users_fix.php olarak yeniden adlandırıldı)
|   |-- admin_auth_check.php # Yönetici oturum kontrolü (admin_auth_check_fix.php olarak yeniden adlandırıldı)
|   `-- admin_login_check.php # Yönetici giriş işlemi mantığı
|
|-- database_schema.sql      # Veritabanı şemasını oluşturmak için SQL betiği
|-- test_data.sql            # Test verilerini (kullanıcılar, yönetici, eşleşmeler) eklemek için SQL betiği
|-- todo.md                  # Geliştirme görev listesi (bu dosya)
`-- README.md              # Bu dosya
```

## Kurulum

1.  **Web Sunucusu:** PHP ve MySQL destekleyen bir web sunucusuna (Apache, Nginx vb.) ihtiyacınız var.
2.  **Veritabanı:**
    *   Bir MySQL veritabanı oluşturun (örneğin, `infernova_db`).
    *   Bir veritabanı kullanıcısı oluşturun ve bu kullanıcıya oluşturduğunuz veritabanı üzerinde tüm yetkileri verin.
    *   `database_schema.sql` dosyasını kullanarak veritabanı tablolarını oluşturun (phpMyAdmin veya komut satırı aracılığıyla içe aktarın).
3.  **Yapılandırma:**
    *   `config/db.php` dosyasını açın ve veritabanı bağlantı bilgilerinizi (host, kullanıcı adı, şifre, veritabanı adı) güncelleyin.
4.  **Dosyaları Yükleme:** Proje dosyalarını web sunucunuzun erişilebilir bir dizinine (genellikle `public_html`, `www` veya `htdocs`) yükleyin. `public` klasörü web kök dizini olmalıdır veya sunucu yapılandırmanız bu klasörü işaret etmelidir.
5.  **Klasör İzinleri:** `public/uploads` klasörünü oluşturun ve web sunucusunun bu klasöre yazma izni olduğundan emin olun (örneğin, `chmod 777 public/uploads` - güvenlik açısından daha kısıtlı izinler tercih edilebilir).
6.  **Test Verisi (İsteğe Bağlı):** Uygulamayı test etmek için `test_data.sql` dosyasını veritabanınıza aktarın. Bu betik, bir yönetici hesabı ve birkaç test kullanıcısı oluşturur.

## Çalıştırma

Web tarayıcınızdan sitenizin ana URL'sine gidin (örneğin, `http://siteniz.com/`).

## Yönetici Erişimi

*   Yönetici paneline erişmek için `/admin/login.php` adresine gidin.
*   `test_data.sql` betiğini çalıştırdıysanız, varsayılan yönetici bilgileri:
    *   **Kullanıcı Adı:** admin@example.com
    *   **Şifre:** Cem03167826

## Notlar

*   Bu, temel özelliklere sahip bir başlangıç projesidir.
*   Güvenlik önlemleri (giriş doğrulama, SQL injection koruması vb.) temel düzeydedir ve production ortamı için güçlendirilmelidir.
*   CSS stilleri temel düzeydedir ve geliştirilebilir.
*   Gerçek zamanlı mesajlaşma gibi özellikler eklenmemiştir.
*   Hata yönetimi daha detaylı hale getirilebilir.
