<?php
require_once __DIR__ . '/admin_auth_check.php'; // Fixed path

// Placeholder for fetching stats (Requires DB)
$total_users = 0; // Default
$online_users = 0; // Default
$total_matches = 0; // Default

// --- Database Interaction ---
require_once __DIR__ . '/../config/db.php'; // Fixed path
$mysqli = connect_db(); // Establish connection

// Fetch total users
$result_total = $mysqli->query("SELECT COUNT(*) as count FROM users WHERE is_admin = 0"); // Exclude admin users from count
if ($result_total) {
    $total_users = $result_total->fetch_assoc()['count'];
    $result_total->free();
} else {
    error_log("Admin DB Error (total users): " . $mysqli->error);
}

// Fetch online users (Users logged in within the last 5 minutes)
$online_threshold_time = date('Y-m-d H:i:s', strtotime('-5 minutes'));
$sql_online = "SELECT COUNT(*) as count FROM users WHERE last_login >= ? AND is_admin = 0"; // Use last_login
if ($stmt_online = $mysqli->prepare($sql_online)) {
    $stmt_online->bind_param("s", $online_threshold_time);
    $stmt_online->execute();
    $result_online = $stmt_online->get_result();
    $online_users = $result_online->fetch_assoc()['count'];
    $stmt_online->close();
} else {
     error_log("Admin DB Error (online users): " . $mysqli->error);
}


// Fetch total matches (Count all rows in matches table)
$result_matches = $mysqli->query("SELECT COUNT(*) as count FROM matches");
if ($result_matches) {
    $total_matches = $result_matches->fetch_assoc()['count'];
    $result_matches->free();
} else {
     error_log("Admin DB Error (total matches): " . $mysqli->error);
}

close_db($mysqli);


?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Yönetim Paneli</title>
    <style>
        body { font-family: sans-serif; margin: 0; display: flex; min-height: 100vh; background-color: #f4f4f4; }
        .sidebar { width: 220px; background: #2c3e50; /* Dark blue */ color: white; flex-shrink: 0; display: flex; flex-direction: column; }
        .sidebar h2 { text-align: center; color: #ecf0f1; /* Light grey */ margin: 20px 0; padding-bottom: 20px; border-bottom: 1px solid #34495e; /* Slightly darker blue */ font-size: 1.5em; }
        .sidebar ul { list-style: none; padding: 0; margin: 0; flex-grow: 1; }
        .sidebar ul li a {
            display: block;
            padding: 15px 25px;
            color: #bdc3c7; /* Silver */
            text-decoration: none;
            border-left: 4px solid transparent;
            transition: all 0.3s ease;
        }
        .sidebar ul li a:hover {
            background: #34495e; /* Slightly darker blue */
            color: #fff;
            border-left-color: #e91e63; /* Pink accent */
        }
        .sidebar ul li a.active {
            background: #34495e;
            color: #fff;
            font-weight: bold;
            border-left-color: #e91e63;
        }
        .sidebar .logout-link {
             margin-top: auto; /* Pushes logout to bottom */
        }
         .sidebar .logout-link a {
             border-top: 1px solid #34495e;
             border-bottom: none; /* Remove bottom border for logout */
         }

        .main-content { flex-grow: 1; padding: 30px; }
        .main-content h1 {
            margin-top: 0;
            color: #2c3e50;
            border-bottom: 2px solid #e91e63;
            padding-bottom: 10px;
            margin-bottom: 30px;
        }
        .stats-container { display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 25px; margin-top: 20px; }
        .stat-box {
            background: #fff;
            padding: 25px;
            border-radius: 8px;
            box-shadow: 0 4px 10px rgba(0,0,0,0.08);
            text-align: center;
            transition: transform 0.2s ease, box-shadow 0.2s ease;
        }
        .stat-box:hover {
            transform: translateY(-5px);
            box-shadow: 0 6px 15px rgba(0,0,0,0.12);
        }
        .stat-box h3 {
            margin-top: 0;
            color: #555;
            font-size: 1.1em;
            margin-bottom: 15px;
        }
        .stat-box p {
            font-size: 2.5em;
            font-weight: bold;
            margin: 0;
            color: #e91e63;
        }

        @media (max-width: 768px) {
            body { flex-direction: column; }
            .sidebar { width: 100%; min-height: auto; flex-direction: row; justify-content: space-between; align-items: center; padding: 0 10px; }
            .sidebar h2 { margin: 10px 0; padding: 0; border: none; font-size: 1.2em; }
            .sidebar ul { display: flex; flex-grow: 0; border-bottom: none; }
            .sidebar ul li a { padding: 10px 15px; border: none; }
            .sidebar ul li a:hover, .sidebar ul li a.active { background: #34495e; border-left: none; }
            .sidebar .logout-link { margin-top: 0; }
            .main-content { padding: 20px; }
            .stats-container { grid-template-columns: 1fr; }
        }
    </style>
</head>
<body>
    <div class="sidebar">
        <h2>Yönetim</h2>
        <ul>
            <li><a href="index.php" class="active">Panel</a></li>
            <li><a href="users.php">Kullanıcılar</a></li>
            <!-- Add more links later (e.g., Photos, Settings) -->
        </ul>
         <div class="logout-link">
             <ul><li><a href="logout.php">Çıkış Yap</a></li></ul>
         </div>
    </div>
    <div class="main-content">
        <h1>Yönetim Paneli</h1>
        <p>Uygulama yönetimine hoş geldiniz.</p>

        <div class="stats-container">
            <div class="stat-box">
                <h3>Toplam Kullanıcı</h3>
                <p><?php echo $total_users; ?></p>
            </div>
            <div class="stat-box">
                <h3>Çevrimiçi Kullanıcı</h3>
                <p><?php echo $online_users; ?></p>
            </div>
            <div class="stat-box">
                <h3>Toplam Eşleşme</h3>
                <p><?php echo $total_matches; ?></p>
            </div>
        </div>

        <!-- More dashboard widgets can be added here -->

    </div>
</body>
</html>