<?php
session_start(); // Start the session

// Include database configuration
require_once __DIR__ . '/../db.php';// Establish database connection
$mysqli = connect_db();

// Check if the form was submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = trim($_POST["email"]);
    $password = $_POST["password"];

    // --- Basic Validation ---
    if (empty($email) || empty($password)) {
        close_db($mysqli);
        header("Location: ../public/login.php?error=empty_fields"); exit;
    }

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        close_db($mysqli);
        header("Location: ../public/login.php?error=invalid_email"); exit;
    }

    // --- Database Interaction ---

    // Fetch user from database
    $sql = "SELECT user_id, email, password_hash, membership_id FROM users WHERE email = ?";
    if ($stmt = $mysqli->prepare($sql)) {
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows == 1) {
            $user = $result->fetch_assoc();

            // Verify password
            if (password_verify($password, $user["password_hash"])) {
                // Password is correct, start session
                session_regenerate_id(true); // Prevent session fixation
                $_SESSION["user_id"] = $user["user_id"];
                $_SESSION["email"] = $user["email"];
                $_SESSION["membership_id"] = $user["membership_id"];
                $_SESSION["loggedin"] = true;

                // Update last login time and online status
                // Assuming 'last_login' and 'online_status' columns exist as per previous schema attempts
                $update_sql = "UPDATE users SET last_login = CURRENT_TIMESTAMP, online_status = TRUE WHERE user_id = ?";
                if ($update_stmt = $mysqli->prepare($update_sql)) {
                    $update_stmt->bind_param("i", $user["user_id"]);
                    $update_stmt->execute();
                    $update_stmt->close();
                } else {
                    // Log error but don't block login if update fails
                    error_log("Failed to update last login/online status for user ID: " . $user["user_id"] . " Error: " . $mysqli->error);
                }

                $stmt->close(); // Close the main statement
                close_db($mysqli); // Close DB connection
                header("Location: ../public/dashboard.php");
                exit;
            } else {
                // Incorrect password
                $stmt->close();
                close_db($mysqli);
                header("Location: ../public/login.php?error=invalid_credentials"); exit;
            }
        } else {
            // User not found
            $stmt->close();
            close_db($mysqli);
            header("Location: ../public/login.php?error=invalid_credentials"); exit; // Use same error for security
        }
    } else {
        error_log("Database error (login prepare): " . $mysqli->error);
        close_db($mysqli);
        header("Location: ../public/login.php?error=db_error"); exit;
    }

} else {
    // If not a POST request, redirect to login page
    if (isset($mysqli) && $mysqli) { // Check if connection exists before closing
       close_db($mysqli);
    }
    header("Location: ../public/login.php");
    exit;
}
?>