<?php
session_start(); // Initialize the session

// Include DB config for potential future use (e.g., updating online status)
// require_once __DIR__ . '/../config/db.php';

// Update online status to FALSE (Requires working DB connection)
/*
if (isset($_SESSION["user_id"])) {
    $user_id = $_SESSION["user_id"];
    $update_sql = "UPDATE users SET online_status = FALSE WHERE user_id = ?";
    if ($update_stmt = $mysqli->prepare($update_sql)) {
        $update_stmt->bind_param("i", $user_id);
        $update_stmt->execute();
        $update_stmt->close();
    }
    // close_db($mysqli); // Close DB if opened
}
*/

// Unset all of the session variables
$_SESSION = array();

// Destroy the session.
if (ini_get("session.use_cookies")) {
    $params = session_get_cookie_params();
    setcookie(session_name(), '', time() - 42000,
        $params["path"], $params["domain"],
        $params["secure"], $params["httponly"]
    );
}
session_destroy();

// Redirect to login page
header("location: login.php");
exit;
?>
