<?php
// Check if user is logged in
require_once __DIR__ . '/../includes/auth_check.php';

// Include database configuration
require_once __DIR__ . '/../config/db.php';

$user_id = $_SESSION['user_id'];

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $match_id = filter_input(INPUT_POST, 'match_id', FILTER_VALIDATE_INT);
    $receiver_id = filter_input(INPUT_POST, 'receiver_id', FILTER_VALIDATE_INT);
    $content = trim($_POST['content'] ?? '');

    // Validate input
    if (!$match_id || !$receiver_id || empty($content)) {
        // Redirect back with error
        header("Location: ../public/conversation.php?match_id=" . $match_id . "&user_id=" . $receiver_id . "&error=empty");
        exit;
    }

    // Prevent sending messages to self
    if ($receiver_id == $user_id) {
         header("Location: ../public/conversation.php?match_id=" . $match_id . "&user_id=" . $receiver_id . "&error=self");
        exit;
    }

    // --- Database Interaction ---
    
    // Verify the match exists and the user is part of it (important security check)
    $sql_verify = "SELECT match_id FROM matches WHERE match_id = ? AND (user1_id = ? OR user2_id = ?)";
    if ($stmt_verify = $mysqli->prepare($sql_verify)) {
        $stmt_verify->bind_param("iii", $match_id, $user_id, $user_id);
        $stmt_verify->execute();
        $stmt_verify->store_result();
        if ($stmt_verify->num_rows == 0) {
            // If no match found or user not part of it, redirect with error
            $stmt_verify->close();
            header("Location: ../public/messages.php?error=invalid_match");
            exit;
        }
        $stmt_verify->close();
    } else {
        error_log("Database error (verify match): " . $mysqli->error);
        header("Location: ../public/conversation.php?match_id=" . $match_id . "&user_id=" . $receiver_id . "&error=db_error");
        exit;
    }

    // Insert the message
    $sql_insert = "INSERT INTO messages (match_id, sender_id, receiver_id, content, created_at) VALUES (?, ?, ?, ?, NOW())";
    if ($stmt_insert = $mysqli->prepare($sql_insert)) {
        $stmt_insert->bind_param("iiis", $match_id, $user_id, $receiver_id, $content);
        if (!$stmt_insert->execute()) {
            error_log("Message send failed: " . $stmt_insert->error);
            $stmt_insert->close();
            header("Location: ../public/conversation.php?match_id=" . $match_id . "&user_id=" . $receiver_id . "&error=send_failed");
            exit;
        }
        $stmt_insert->close();
    } else {
        error_log("Database error (prepare insert message): " . $mysqli->error);
        header("Location: ../public/conversation.php?match_id=" . $match_id . "&user_id=" . $receiver_id . "&error=db_error");
        exit;
    }

    close_db($mysqli);
    

    // --- Redirect back to the conversation ---
    // Redirect ensures the page reloads with the new message displayed
    header("Location: ../public/conversation.php?match_id=" . $match_id . "&user_id=" . $receiver_id);
    exit;

} else {
    // If not a POST request, redirect to messages list
    header("Location: ../public/messages.php");
    exit;
}
?>
