<?php
// Check if user is logged in
require_once __DIR__ . 
'/../includes/auth_check.php
';

// Placeholder for fetching potential matches (Requires DB)
// In a real app, fetch users who haven't been liked/disliked by the current user
// and potentially match based on preferences (location, age, interests etc.)

// Dummy data for demonstration
$potential_matches = [
    [
        'user_id' => 2,
        'username' => 'JaneDoe',
        'age' => 28,
        'location' => 'Ankara',
        'bio' => 'Gezmeyi ve yeni yerler keşfetmeyi severim.',
        'photos' => ['uploads/placeholder1.jpg'] // Placeholder image path
    ],
    [
        'user_id' => 3,
        'username' => 'AlexSmith',
        'age' => 32,
        'location' => 'İzmir',
        'bio' => 'Müzik ve sanat tutkunu.',
        'photos' => ['uploads/placeholder2.jpg'] // Placeholder image path
    ],
    // Add more dummy users as needed
];

// Simple logic to pick one match to show (e.g., the first one not yet seen)
// This needs proper state management (e.g., session or DB) in a real app
$current_match = null;
if (!empty($potential_matches)) {
    // In a real app, you'd track which profiles the user has already seen/swiped
    // For now, just show the first one as an example
    $current_match = $potential_matches[0]; 
}

?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Eşleşme Bul</title>
    <!-- Add basic styling and JS for swipe later -->
    <style>
        .match-card {
            border: 1px solid #ccc;
            padding: 20px;
            margin: 20px auto;
            max-width: 400px;
            text-align: center;
        }
        .match-card img {
            max-width: 100%;
            max-height: 300px;
            display: block;
            margin: 0 auto 15px;
        }
        .actions button {
            padding: 10px 20px;
            margin: 0 10px;
            font-size: 16px;
            cursor: pointer;
        }
        .actions .dislike { background-color: #f44336; color: white; }
        .actions .like { background-color: #4CAF50; color: white; }
    </style>
</head>
<body>
    <h2>Eşleşme Bul</h2>
    <nav>
        <ul>
            <li><a href="dashboard.php">Panele Dön</a></li>
            <li><a href="profile.php">Profili Düzenle</a></li>
            <li><a href="messages.php">Mesajlar</a></li>
            <li><a href="logout.php">Çıkış Yap</a></li>
        </ul>
    </nav>

    <?php if ($current_match): ?>
        <div class="match-card" id="match-<?php echo $current_match['user_id']; ?>">
            <?php if (!empty($current_match['photos'])): ?>
                <img src="<?php echo htmlspecialchars($current_match['photos'][0]); ?>" alt="<?php echo htmlspecialchars($current_match['username']); ?>">
            <?php else: ?>
                <img src="uploads/default_avatar.png" alt="Varsayılan Avatar"> <!-- Add a default avatar -->
            <?php endif; ?>
            <h3><?php echo htmlspecialchars($current_match['username']); ?>, <?php echo htmlspecialchars($current_match['age']); ?></h3>
            <p><strong>Yaşadığı Yer:</strong> <?php echo htmlspecialchars($current_match['location']); ?></p>
            <p><?php echo htmlspecialchars($current_match['bio']); ?></p>
            
            <div class="actions">
                <!-- Basic form submission for like/dislike -->
                <form action="../includes/like_process.php" method="post" style="display: inline;">
                    <input type="hidden" name="target_user_id" value="<?php echo $current_match['user_id']; ?>">
                    <input type="hidden" name="action" value="dislike">
                    <button type="submit" class="dislike">Beğenme (Sol)</button>
                </form>
                <form action="../includes/like_process.php" method="post" style="display: inline;">
                    <input type="hidden" name="target_user_id" value="<?php echo $current_match['user_id']; ?>">
                    <input type="hidden" name="action" value="like">
                    <button type="submit" class="like">Beğen (Sağ)</button>
                </form>
            </div>
        </div>
        <!-- Add JavaScript here later to handle swipe and loading next profile via AJAX -->
    <?php else: ?>
        <p>Gösterilecek yeni kullanıcı bulunamadı.</p>
    <?php endif; ?>

</body>
</html>
