-- Test Data and Admin User Creation for Dating App (Improved)

-- Note: Run this script AFTER registering your main user (e.g., mahqmaster@gmail.com).

-- Insert initial membership types if they don't exist (optional, schema file already does this)
-- INSERT IGNORE INTO memberships (membership_id, name, description) VALUES
-- (1, 'Standard', 'Basic free membership'),
-- (2, 'Premium', 'Enhanced features membership'),
-- (3, 'Gold', 'Top-tier membership with all features');

-- 1. Create the Admin User
-- Using the password hash for 'Cem03167826'
INSERT INTO `users` (`email`, `password_hash`, `membership_id`, `is_admin`)
VALUES (
    'admin@example.com', -- Use a valid email for the admin
    '$2y$10$48tlQXRWSLakdj.6H9.DfOTwOkS5QGsljb1khzX214zxTWDcmKnUC',
    3, -- Assign Gold membership to admin, or choose another
    TRUE -- Set the admin flag
);
SET @admin_user_id = LAST_INSERT_ID();

-- Create a basic profile for the admin user
INSERT INTO `profiles` (`user_id`, `username`, `birthdate`, `location`)
VALUES (
    @admin_user_id,
    'AdminUser',
    '1990-01-01', -- Example birthdate
    'Server Room'
);

-- 2. Create Test Users
-- Using the same password hash for 'Cem03167826' for simplicity
INSERT INTO `users` (`email`, `password_hash`, `membership_id`) VALUES
(
    'testuser1@example.com',
    '$2y$10$48tlQXRWSLakdj.6H9.DfOTwOkS5QGsljb1khzX214zxTWDcmKnUC',
    1 -- Standard Membership
),
(
    'testuser2@example.com',
    '$2y$10$48tlQXRWSLakdj.6H9.DfOTwOkS5QGsljb1khzX214zxTWDcmKnUC',
    2 -- Premium Membership
),
(
    'testuser3@example.com',
    '$2y$10$48tlQXRWSLakdj.6H9.DfOTwOkS5QGsljb1khzX214zxTWDcmKnUC',
    3 -- Gold Membership
);

-- Get the IDs of the newly inserted test users (more robustly)
SET @user1_id = (SELECT user_id FROM users WHERE email = 'testuser1@example.com');
SET @user2_id = (SELECT user_id FROM users WHERE email = 'testuser2@example.com');
SET @user3_id = (SELECT user_id FROM users WHERE email = 'testuser3@example.com');

-- Insert profiles for the test users with birthdates
INSERT INTO `profiles` (`user_id`, `username`, `birthdate`, `location`, `interests`, `bio`) VALUES
(
    @user1_id,
    'Test Kullanıcı 1',
    '1999-05-10', -- Example birthdate (approx 25)
    'Ankara',
    'Müzik, Seyahat',
    'Merhaba, ben Test Kullanıcı 1.'
),
(
    @user2_id,
    'Test Kullanıcı 2',
    '1994-03-15', -- Example birthdate (approx 30)
    'İstanbul',
    'Spor, Film',
    'Yeni insanlarla tanışmayı seviyorum.'
),
(
    @user3_id,
    'Test Kullanıcı 3',
    '1996-11-20', -- Example birthdate (approx 28)
    'İzmir',
    'Kitap, Doğa',
    'Sakin biriyim.'
);

-- Add placeholder photos for test users (Optional)
-- Replace 'uploads/placeholderX.jpg' with actual paths if you have placeholder images
-- INSERT INTO `photos` (`user_id`, `file_path`, `upload_order`) VALUES
-- (@user1_id, 'uploads/placeholder1.jpg', 1),
-- (@user2_id, 'uploads/placeholder2.jpg', 1),
-- (@user3_id, 'uploads/placeholder3.jpg', 1);

-- 3. Create a Match and Sample Message
-- !!! IMPORTANT: Ensure you have registered 'mahqmaster@gmail.com' BEFORE running this part !!!
SET @your_user_id = (SELECT user_id FROM users WHERE email = 'mahqmaster@gmail.com' LIMIT 1);

-- Check if both users exist before creating match
SELECT @your_user_id, @user1_id;

-- Insert match ensuring user1_id < user2_id
-- Make sure @your_user_id and @user1_id are not NULL
INSERT INTO `matches` (`user1_id`, `user2_id`)
SELECT LEAST(@your_user_id, @user1_id), GREATEST(@your_user_id, @user1_id)
WHERE @your_user_id IS NOT NULL AND @user1_id IS NOT NULL;

-- Add a sample message from Test Kullanıcı 1 to you
-- Get the match_id (handle potential NULL if users didn't exist)
SET @match_id_for_message = (SELECT match_id FROM matches WHERE (user1_id = @your_user_id AND user2_id = @user1_id) OR (user1_id = @user1_id AND user2_id = @your_user_id) LIMIT 1);

-- Insert message only if match exists
INSERT INTO `messages` (`match_id`, `sender_id`, `receiver_id`, `content`)
SELECT @match_id_for_message, @user1_id, @your_user_id, 'Merhaba! Eşleştiğimize sevindim.'
WHERE @match_id_for_message IS NOT NULL;


